﻿using System;
using System.Windows.Data;

namespace Microscopic_Traffic_Simulator.Converters
{
    /// <summary>
    /// Converter from TimeSpan to string representation HH:MM:SS.SSS
    /// </summary>
    class FromTimeSpanToHoursString : IValueConverter
    {
        /// <summary>
        /// Convert from TimeSpan to string representation HH:MM:SS.SSS
        /// </summary>
        /// <param name="value">Time.</param>
        /// <param name="targetType">Target type which is string.</param>
        /// <param name="parameter">Parameter defined in UI. Not used.</param>
        /// <param name="culture">Current culture info.</param>
        /// <returns>String representation of time (HH:MM:SS.SSS).</returns>
        public object Convert(object value, Type targetType, object parameter,
            System.Globalization.CultureInfo culture)
        {
            TimeSpan valueTime = (TimeSpan)value;
            if (valueTime == TimeSpan.MaxValue)
                return string.Empty;
            return string.Format("{0}:{1:00}:{2:00}.{3:000}", (int)valueTime.TotalHours,
                valueTime.Minutes, valueTime.Seconds, valueTime.Milliseconds);
        }

        /// <summary>
        /// Not implemented conversion from string to TimeSpan
        /// </summary>
        /// <param name="value">String with time.</param>
        /// <param name="targetType">Target type which is TimeSpan.</param>
        /// <param name="parameter">Parameter defined in UI. Not used.</param>
        /// <param name="culture">Current culture info.</param>
        /// <returns>Object of type TimeSpan.</returns>
        public object ConvertBack(object value, Type targetType, object parameter,
            System.Globalization.CultureInfo culture)
        {
            TimeSpan result;
            if (TimeSpan.TryParse((string)value, out result))
            {
                return result;
            }
            else
            {
                return null;
            }
        }
    }
}